from cryptography.hazmat.primitives.ciphers import Cipher, algorithms, modes
from cryptography.hazmat.backends import default_backend
import binascii
import os

# Key and IV from the OpenSSL command
key = binascii.unhexlify("76505a414c376c40413734694e536266")  # 16 bytes
iv = binascii.unhexlify("6b333339553443583151235530255e7a")   # 16 bytes
input_file = "MAIN20X.bin"
output_file = "MAIN20X_decrypted.bin"

# Read the encrypted file
try:
    with open(input_file, "rb") as f:
        ciphertext = f.read()
except FileNotFoundError:
    print(f"Error: Input file '{input_file}' not found.")
    exit(1)

# Verify input size is multiple of block size (16 bytes for AES)
if len(ciphertext) % 16 != 0:
    print("Error: Input file size is not a multiple of 16 bytes (required for -nopad).")
    exit(1)

# Set up AES-128-CBC cipher
cipher = Cipher(algorithms.AES(key), modes.CBC(iv), backend=default_backend())
decryptor = cipher.decryptor()

# Decrypt the data
try:
    plaintext = decryptor.update(ciphertext) + decryptor.finalize()
except Exception as e:
    print(f"Error during decryption: {e}")
    exit(1)

# Write the decrypted data to output file
with open(output_file, "wb") as f:
    f.write(plaintext)

print(f"Decryption successful. Output written to '{output_file}'.")